using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace nsAlienMobileSDK
{
    public partial class frmProgressDlg : Form
    {
        private bool mbClosing = false;
        private static readonly object moClosingLock = new object();
        private System.Windows.Forms.Timer timer1 = new Timer();
        internal bool mbSuccess = false;
        private int miTimeout = 4;  // minutes
        private DateTime mStarted;

        public frmProgressDlg()
        {
            InitializeComponent();
            timer1.Interval = 10;
            timer1.Enabled = false;
            timer1.Tick += new EventHandler(timer1_Tick);
            this.Closing += new CancelEventHandler(frmProgressDlg_Closing);
        }

        void frmProgressDlg_Closing(object sender, CancelEventArgs e)
        {
            lock (moClosingLock)
            {
                mbClosing = true;
            }
            Debug.WriteLine("Closing timer at: " + DateTime.Now.Second.ToString());
        }

        void timer1_Tick(object sender, EventArgs e)
        {
            lock (moClosingLock)
            {
                if (!mbClosing)
                {
                    if (progressBar1.Value < 100)
                        progressBar1.Value++;
                    else
                        progressBar1.Value = 0;
                }

                TimeSpan timespan = DateTime.Now - mStarted;
                if (miTimeout < timespan.Minutes)
                    this.Close();
            }
        }

        private void frmProgressDlg_Load(object sender, EventArgs e)
        {
            lock (moClosingLock)
            {
                mbClosing = false;
            }

            mStarted = DateTime.Now;

            timer1.Enabled = true;

            Debug.WriteLine("Starting timer at: " + mStarted.Second.ToString());
        }
    }
}